/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lane.eui;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.ATMAddressInput;
import ibm.nways.jdm.eui.ATMAddressInputRO;
import ibm.nways.jdm.eui.BooleanInput;
import ibm.nways.jdm.eui.BooleanInputRO;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.HexInputRO;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInput;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.eui.TimeTicksRO;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import ibm.nways.lane.model.LesModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class LesGeneralPanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "LES";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel Les_model;
    protected selectionListSection selectionListPropertySection;
    protected lesConfDetailSection lesConfDetailPropertySection;
    protected ModelInfo LesConfTableInfo;
    protected ModelInfo PanelInfo;
    protected int LesConfTableIndex;
    protected LesConfTable LesConfTableData;
    protected TableColumns LesConfTableColumns;
    protected TableStatus LesConfTableStatus;
    protected static TableColumn[] LesConfTableCols = new TableColumn[]{new TableColumn("Index.LesConfIndex", "Index", 3, true), new TableColumn("Panel.LesElanName", "ELAN Name", 5, false), new TableColumn("Panel.LesOperStatus", "Operational State", 16, false), new TableColumn("Panel.LesAdminStatus", "Desired State", 16, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.lane.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.lane.eui.LesGeneralPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel LesGeneral");
        }
    }

    public static String getTitle() {
        LesGeneralPanel.loadStatics();
        if (myResources != null) {
            title = LesGeneralPanel.getNLSString("LesGeneralPanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            LesGeneralPanel.loadStatics();
        }
        return enumStrings;
    }

    public LesGeneralPanel() {
        LesGeneralPanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return LesGeneralPanel.getTitle();
    }

    protected void getModels() {
        this.Les_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addselectionListSection();
        this.addlesConfDetailSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addselectionListSection() {
        this.selectionListPropertySection = new selectionListSection();
        this.selectionListPropertySection.layoutSection();
        this.addSection(LesGeneralPanel.getNLSString("selectionListSectionTitle"), this.selectionListPropertySection);
    }

    protected void addlesConfDetailSection() {
        this.lesConfDetailPropertySection = new lesConfDetailSection();
        this.lesConfDetailPropertySection.layoutSection();
        this.addSection(LesGeneralPanel.getNLSString("lesConfDetailSectionTitle"), this.lesConfDetailPropertySection);
    }

    protected void panelRowChange() {
        if (this.selectionListPropertySection != null) {
            this.selectionListPropertySection.rowChange();
        }
        if (this.lesConfDetailPropertySection != null) {
            this.lesConfDetailPropertySection.rowChange();
        }
    }

    public void filterPanelInfos(Vector vector) {
    }

    public int getInitialLesConfTableRow() {
        return 0;
    }

    public ModelInfo initialLesConfTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(LesGeneralPanel.getNLSString("startResetMsg"));
        this.LesConfTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(LesGeneralPanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(LesGeneralPanel.getNLSString("endResetMsg")) + " " + LesGeneralPanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.PanelInfo = new ModelInfo();
        this.PanelInfo.add("Index.LesConfIndex", (Serializable)this.LesConfTableData.getValueAt("Index.LesConfIndex", this.LesConfTableIndex));
        this.errorsFound = false;
        this.displayMsg(LesGeneralPanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.LesConfTableInfo = (ModelInfo)this.LesConfTableData.elementAt(this.LesConfTableIndex);
            this.LesConfTableInfo = this.LesConfTableData.setRow();
            this.LesConfTableData.setElementAt(this.LesConfTableInfo, this.LesConfTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(LesGeneralPanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(LesGeneralPanel.getNLSString("endApplyMsg")) + " " + LesGeneralPanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(LesGeneralPanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.LesConfTableData = new LesConfTable();
        this.LesConfTableIndex = 0;
        this.LesConfTableColumns = new TableColumns(LesConfTableCols);
        if (this.Les_model instanceof RemoteModelWithStatus) {
            try {
                this.LesConfTableStatus = (TableStatus)this.Les_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class selectionListSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component LesConfTableField;
        Label LesConfTableFieldLabel;
        boolean LesConfTableFieldWritable = false;

        public selectionListSection() {
            LesGeneralPanel.this = LesGeneralPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createLesConfTableField() {
            EuiGrid euiGrid = new EuiGrid(LesGeneralPanel.this.LesConfTableData, LesGeneralPanel.this.LesConfTableColumns, true);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(LesGeneralPanel.this.initialLesConfTableRow());
            this.addTable(LesGeneralPanel.getNLSString("LesConfTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.LesConfTableField = this.createLesConfTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                LesGeneralPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("accessDataMsg"));
            LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.LesConfTableField).refresh();
            LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("endTableGetMsg"));
            LesGeneralPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.LesConfTableField) {
                        LesGeneralPanel.this.LesConfTableIndex = euiGridEvent.getRow();
                    }
                    LesGeneralPanel.this.LesConfTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.LesConfTableField).deselectAllRows();
                    LesGeneralPanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.LesConfTableField) {
                        LesGeneralPanel.this.LesConfTableIndex = 0;
                    }
                    LesGeneralPanel.this.selectionListPropertySection.reset();
                    LesGeneralPanel.this.lesConfDetailPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class lesConfDetailSection
    extends PropertySection {
        ModelInfo chunk;
        Component lesAtmAddrSpecField;
        Component lesAtmAddrMaskField;
        Component lesAtmAddrActualField;
        Component lesElanNameField;
        Component lesLanTypeField;
        Component lesLastChangeField;
        Component lesMaxFrameSizeField;
        Component lesControlTimeOutField;
        Component lesOperStatusField;
        Component lesAdminStatusField;
        Component validateJoinsWithLecsField;
        Component use2ControlDistributeVccsField;
        Component redundancyEnabledField;
        Component redundancyRoleField;
        Component redundancyAtmAddrField;
        Component ibmLeServerXLesMinLecIDField;
        Component ibmLeServerXLesMaxLecIDField;
        Label lesAtmAddrSpecFieldLabel;
        Label lesAtmAddrMaskFieldLabel;
        Label lesAtmAddrActualFieldLabel;
        Label lesElanNameFieldLabel;
        Label lesLanTypeFieldLabel;
        Label lesLastChangeFieldLabel;
        Label lesMaxFrameSizeFieldLabel;
        Label lesControlTimeOutFieldLabel;
        Label lesOperStatusFieldLabel;
        Label lesAdminStatusFieldLabel;
        Label validateJoinsWithLecsFieldLabel;
        Label use2ControlDistributeVccsFieldLabel;
        Label redundancyEnabledFieldLabel;
        Label redundancyRoleFieldLabel;
        Label redundancyAtmAddrFieldLabel;
        Label ibmLeServerXLesMinLecIDFieldLabel;
        Label ibmLeServerXLesMaxLecIDFieldLabel;
        boolean lesAtmAddrSpecFieldWritable = false;
        boolean lesAtmAddrMaskFieldWritable = false;
        boolean lesAtmAddrActualFieldWritable = false;
        boolean lesElanNameFieldWritable = false;
        boolean lesLanTypeFieldWritable = false;
        boolean lesLastChangeFieldWritable = false;
        boolean lesMaxFrameSizeFieldWritable = false;
        boolean lesControlTimeOutFieldWritable = false;
        boolean lesOperStatusFieldWritable = false;
        boolean lesAdminStatusFieldWritable = false;
        boolean validateJoinsWithLecsFieldWritable = false;
        boolean use2ControlDistributeVccsFieldWritable = false;
        boolean redundancyEnabledFieldWritable = false;
        boolean redundancyRoleFieldWritable = false;
        boolean redundancyAtmAddrFieldWritable = false;
        boolean ibmLeServerXLesMinLecIDFieldWritable = false;
        boolean ibmLeServerXLesMaxLecIDFieldWritable = false;

        public lesConfDetailSection() {
            LesGeneralPanel.this = LesGeneralPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createlesAtmAddrSpecField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesAtmAddrSpec.access", "read-write");
            LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesAtmAddrSpec.length", "20");
            this.lesAtmAddrSpecFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesAtmAddrSpecFieldLabel = new Label(LesGeneralPanel.getNLSString("lesAtmAddrSpecLabel"), 2);
            if (this.lesAtmAddrSpecFieldWritable) {
                ATMAddressInput aTMAddressInput = new ATMAddressInput();
                this.addRow(this.lesAtmAddrSpecFieldLabel, (Component)aTMAddressInput);
                LesGeneralPanel.this.containsWritableField = true;
                return aTMAddressInput;
            }
            ATMAddressInputRO aTMAddressInputRO = new ATMAddressInputRO();
            this.addRow(this.lesAtmAddrSpecFieldLabel, (Component)aTMAddressInputRO);
            return aTMAddressInputRO;
        }

        protected Serializable getlesAtmAddrSpecField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesAtmAddrSpecField);
            this.validatelesAtmAddrSpecField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesAtmAddrSpecField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesAtmAddrSpecField);
                jDMInput.setValue(object);
                this.validatelesAtmAddrSpecField();
            }
        }

        protected boolean validatelesAtmAddrSpecField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesAtmAddrSpecField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesAtmAddrSpecFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesAtmAddrSpecFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlesAtmAddrMaskField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesAtmAddrMask.access", "read-write");
            String string2 = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesAtmAddrMask.length", "20");
            this.lesAtmAddrMaskFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesAtmAddrMaskFieldLabel = new Label(LesGeneralPanel.getNLSString("lesAtmAddrMaskLabel"), 2);
            if (this.lesAtmAddrMaskFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.lesAtmAddrMaskFieldLabel, (Component)hexInput);
                LesGeneralPanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.lesAtmAddrMaskFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getlesAtmAddrMaskField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesAtmAddrMaskField);
            this.validatelesAtmAddrMaskField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesAtmAddrMaskField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesAtmAddrMaskField);
                jDMInput.setValue(object);
                this.validatelesAtmAddrMaskField();
            }
        }

        protected boolean validatelesAtmAddrMaskField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesAtmAddrMaskField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesAtmAddrMaskFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesAtmAddrMaskFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlesAtmAddrActualField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesAtmAddrActual.access", "read-only");
            LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesAtmAddrActual.length", "20");
            this.lesAtmAddrActualFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesAtmAddrActualFieldLabel = new Label(LesGeneralPanel.getNLSString("lesAtmAddrActualLabel"), 2);
            if (this.lesAtmAddrActualFieldWritable) {
                ATMAddressInput aTMAddressInput = new ATMAddressInput();
                this.addRow(this.lesAtmAddrActualFieldLabel, (Component)aTMAddressInput);
                LesGeneralPanel.this.containsWritableField = true;
                return aTMAddressInput;
            }
            ATMAddressInputRO aTMAddressInputRO = new ATMAddressInputRO();
            this.addRow(this.lesAtmAddrActualFieldLabel, (Component)aTMAddressInputRO);
            return aTMAddressInputRO;
        }

        protected Serializable getlesAtmAddrActualField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesAtmAddrActualField);
            this.validatelesAtmAddrActualField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesAtmAddrActualField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesAtmAddrActualField);
                jDMInput.setValue(object);
                this.validatelesAtmAddrActualField();
            }
        }

        protected boolean validatelesAtmAddrActualField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesAtmAddrActualField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesAtmAddrActualFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesAtmAddrActualFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlesElanNameField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesElanName.access", "read-write");
            String string2 = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesElanName.length", "32");
            this.lesElanNameFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesElanNameFieldLabel = new Label(LesGeneralPanel.getNLSString("lesElanNameLabel"), 2);
            if (this.lesElanNameFieldWritable) {
                StringInput stringInput = new StringInput();
                stringInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.lesElanNameFieldLabel, (Component)stringInput);
                LesGeneralPanel.this.containsWritableField = true;
                return stringInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lesElanNameFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlesElanNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesElanNameField);
            this.validatelesElanNameField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesElanNameField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesElanNameField);
                jDMInput.setValue(object);
                this.validatelesElanNameField();
            }
        }

        protected boolean validatelesElanNameField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesElanNameField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesElanNameFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesElanNameFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlesLanTypeField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesLanType.access", "read-write");
            this.lesLanTypeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesLanTypeFieldLabel = new Label(LesGeneralPanel.getNLSString("lesLanTypeLabel"), 2);
            if (this.lesLanTypeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LesModel.Panel.LesLanTypeEnum.symbolicValues, LesModel.Panel.LesLanTypeEnum.numericValues, LesGeneralPanel.getEnumStrings());
                this.addRow(this.lesLanTypeFieldLabel, (Component)singleChoiceInput);
                LesGeneralPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LesModel.Panel.LesLanTypeEnum.symbolicValues, LesModel.Panel.LesLanTypeEnum.numericValues, LesGeneralPanel.getEnumStrings());
            this.addRow(this.lesLanTypeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlesLanTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesLanTypeField);
            this.validatelesLanTypeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesLanTypeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesLanTypeField);
                jDMInput.setValue(object);
                this.validatelesLanTypeField();
            }
        }

        protected boolean validatelesLanTypeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesLanTypeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesLanTypeFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesLanTypeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlesLastChangeField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesLastChange.access", "read-only");
            this.lesLastChangeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesLastChangeFieldLabel = new Label(LesGeneralPanel.getNLSString("lesLastChangeLabel"), 2);
            if (this.lesLastChangeFieldWritable) {
                TimeTicksRO timeTicksRO = new TimeTicksRO();
                this.addRow(this.lesLastChangeFieldLabel, (Component)timeTicksRO);
                LesGeneralPanel.this.containsWritableField = true;
                return timeTicksRO;
            }
            TimeTicksRO timeTicksRO = new TimeTicksRO();
            this.addRow(this.lesLastChangeFieldLabel, (Component)timeTicksRO);
            return timeTicksRO;
        }

        protected Serializable getlesLastChangeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesLastChangeField);
            this.validatelesLastChangeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesLastChangeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesLastChangeField);
                jDMInput.setValue(object);
                this.validatelesLastChangeField();
            }
        }

        protected boolean validatelesLastChangeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesLastChangeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesLastChangeFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesLastChangeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlesMaxFrameSizeField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesMaxFrameSize.access", "read-write");
            this.lesMaxFrameSizeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesMaxFrameSizeFieldLabel = new Label(LesGeneralPanel.getNLSString("lesMaxFrameSizeLabel"), 2);
            if (this.lesMaxFrameSizeFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LesModel.Panel.LesMaxFrameSizeEnum.symbolicValues, LesModel.Panel.LesMaxFrameSizeEnum.numericValues, LesGeneralPanel.getEnumStrings());
                this.addRow(this.lesMaxFrameSizeFieldLabel, (Component)singleChoiceInput);
                LesGeneralPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LesModel.Panel.LesMaxFrameSizeEnum.symbolicValues, LesModel.Panel.LesMaxFrameSizeEnum.numericValues, LesGeneralPanel.getEnumStrings());
            this.addRow(this.lesMaxFrameSizeFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlesMaxFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesMaxFrameSizeField);
            this.validatelesMaxFrameSizeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesMaxFrameSizeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesMaxFrameSizeField);
                jDMInput.setValue(object);
                this.validatelesMaxFrameSizeField();
            }
        }

        protected boolean validatelesMaxFrameSizeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesMaxFrameSizeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesMaxFrameSizeFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesMaxFrameSizeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlesControlTimeOutField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesControlTimeOut.access", "read-write");
            this.lesControlTimeOutFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesControlTimeOutFieldLabel = new Label(LesGeneralPanel.getNLSString("lesControlTimeOutLabel"), 2);
            if (this.lesControlTimeOutFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(10, 300);
                this.addRow(this.lesControlTimeOutFieldLabel, (Component)numericInput);
                LesGeneralPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.lesControlTimeOutFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getlesControlTimeOutField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesControlTimeOutField);
            this.validatelesControlTimeOutField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesControlTimeOutField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesControlTimeOutField);
                jDMInput.setValue(object);
                this.validatelesControlTimeOutField();
            }
        }

        protected boolean validatelesControlTimeOutField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesControlTimeOutField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesControlTimeOutFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesControlTimeOutFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlesOperStatusField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesOperStatus.access", "read-only");
            this.lesOperStatusFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesOperStatusFieldLabel = new Label(LesGeneralPanel.getNLSString("lesOperStatusLabel"), 2);
            if (this.lesOperStatusFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LesModel.Panel.LesOperStatusEnum.symbolicValues, LesModel.Panel.LesOperStatusEnum.numericValues, LesGeneralPanel.getEnumStrings());
                this.addRow(this.lesOperStatusFieldLabel, (Component)singleChoiceInput);
                LesGeneralPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LesModel.Panel.LesOperStatusEnum.symbolicValues, LesModel.Panel.LesOperStatusEnum.numericValues, LesGeneralPanel.getEnumStrings());
            this.addRow(this.lesOperStatusFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlesOperStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesOperStatusField);
            this.validatelesOperStatusField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesOperStatusField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesOperStatusField);
                jDMInput.setValue(object);
                this.validatelesOperStatusField();
            }
        }

        protected boolean validatelesOperStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesOperStatusField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesOperStatusFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesOperStatusFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createlesAdminStatusField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.LesAdminStatus.access", "read-write");
            this.lesAdminStatusFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.lesAdminStatusFieldLabel = new Label(LesGeneralPanel.getNLSString("lesAdminStatusLabel"), 2);
            if (this.lesAdminStatusFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LesModel.Panel.LesAdminStatusEnum.symbolicValues, LesModel.Panel.LesAdminStatusEnum.numericValues, LesGeneralPanel.getEnumStrings());
                this.addRow(this.lesAdminStatusFieldLabel, (Component)singleChoiceInput);
                LesGeneralPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LesModel.Panel.LesAdminStatusEnum.symbolicValues, LesModel.Panel.LesAdminStatusEnum.numericValues, LesGeneralPanel.getEnumStrings());
            this.addRow(this.lesAdminStatusFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getlesAdminStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesAdminStatusField);
            this.validatelesAdminStatusField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setlesAdminStatusField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.lesAdminStatusField);
                jDMInput.setValue(object);
                this.validatelesAdminStatusField();
            }
        }

        protected boolean validatelesAdminStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.lesAdminStatusField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.lesAdminStatusFieldLabel.setForeground(Color.yellow);
            } else {
                this.lesAdminStatusFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createvalidateJoinsWithLecsField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.ValidateJoinsWithLecs.access", "read-write");
            this.validateJoinsWithLecsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.validateJoinsWithLecsFieldLabel = new Label(LesGeneralPanel.getNLSString("validateJoinsWithLecsLabel"), 2);
            if (this.validateJoinsWithLecsFieldWritable) {
                BooleanInput booleanInput = new BooleanInput();
                this.addRow(this.validateJoinsWithLecsFieldLabel, (Component)booleanInput);
                LesGeneralPanel.this.containsWritableField = true;
                return booleanInput;
            }
            BooleanInputRO booleanInputRO = new BooleanInputRO();
            this.addRow(this.validateJoinsWithLecsFieldLabel, (Component)booleanInputRO);
            return booleanInputRO;
        }

        protected Serializable getvalidateJoinsWithLecsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.validateJoinsWithLecsField);
            this.validatevalidateJoinsWithLecsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setvalidateJoinsWithLecsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.validateJoinsWithLecsField);
                jDMInput.setValue(object);
                this.validatevalidateJoinsWithLecsField();
            }
        }

        protected boolean validatevalidateJoinsWithLecsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.validateJoinsWithLecsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.validateJoinsWithLecsFieldLabel.setForeground(Color.yellow);
            } else {
                this.validateJoinsWithLecsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createuse2ControlDistributeVccsField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.Use2ControlDistributeVccs.access", "read-write");
            this.use2ControlDistributeVccsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.use2ControlDistributeVccsFieldLabel = new Label(LesGeneralPanel.getNLSString("use2ControlDistributeVccsLabel"), 2);
            if (this.use2ControlDistributeVccsFieldWritable) {
                BooleanInput booleanInput = new BooleanInput();
                this.addRow(this.use2ControlDistributeVccsFieldLabel, (Component)booleanInput);
                LesGeneralPanel.this.containsWritableField = true;
                return booleanInput;
            }
            BooleanInputRO booleanInputRO = new BooleanInputRO();
            this.addRow(this.use2ControlDistributeVccsFieldLabel, (Component)booleanInputRO);
            return booleanInputRO;
        }

        protected Serializable getuse2ControlDistributeVccsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.use2ControlDistributeVccsField);
            this.validateuse2ControlDistributeVccsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setuse2ControlDistributeVccsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.use2ControlDistributeVccsField);
                jDMInput.setValue(object);
                this.validateuse2ControlDistributeVccsField();
            }
        }

        protected boolean validateuse2ControlDistributeVccsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.use2ControlDistributeVccsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.use2ControlDistributeVccsFieldLabel.setForeground(Color.yellow);
            } else {
                this.use2ControlDistributeVccsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createredundancyEnabledField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.RedundancyEnabled.access", "read-write");
            this.redundancyEnabledFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.redundancyEnabledFieldLabel = new Label(LesGeneralPanel.getNLSString("redundancyEnabledLabel"), 2);
            if (this.redundancyEnabledFieldWritable) {
                BooleanInput booleanInput = new BooleanInput();
                this.addRow(this.redundancyEnabledFieldLabel, (Component)booleanInput);
                LesGeneralPanel.this.containsWritableField = true;
                return booleanInput;
            }
            BooleanInputRO booleanInputRO = new BooleanInputRO();
            this.addRow(this.redundancyEnabledFieldLabel, (Component)booleanInputRO);
            return booleanInputRO;
        }

        protected Serializable getredundancyEnabledField() {
            JDMInput jDMInput = (JDMInput)((Object)this.redundancyEnabledField);
            this.validateredundancyEnabledField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setredundancyEnabledField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.redundancyEnabledField);
                jDMInput.setValue(object);
                this.validateredundancyEnabledField();
            }
        }

        protected boolean validateredundancyEnabledField() {
            JDMInput jDMInput = (JDMInput)((Object)this.redundancyEnabledField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.redundancyEnabledFieldLabel.setForeground(Color.yellow);
            } else {
                this.redundancyEnabledFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createredundancyRoleField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.RedundancyRole.access", "read-write");
            this.redundancyRoleFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.redundancyRoleFieldLabel = new Label(LesGeneralPanel.getNLSString("redundancyRoleLabel"), 2);
            if (this.redundancyRoleFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(LesModel.Panel.RedundancyRoleEnum.symbolicValues, LesModel.Panel.RedundancyRoleEnum.numericValues, LesGeneralPanel.getEnumStrings());
                this.addRow(this.redundancyRoleFieldLabel, (Component)singleChoiceInput);
                LesGeneralPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(LesModel.Panel.RedundancyRoleEnum.symbolicValues, LesModel.Panel.RedundancyRoleEnum.numericValues, LesGeneralPanel.getEnumStrings());
            this.addRow(this.redundancyRoleFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getredundancyRoleField() {
            JDMInput jDMInput = (JDMInput)((Object)this.redundancyRoleField);
            this.validateredundancyRoleField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setredundancyRoleField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.redundancyRoleField);
                jDMInput.setValue(object);
                this.validateredundancyRoleField();
            }
        }

        protected boolean validateredundancyRoleField() {
            JDMInput jDMInput = (JDMInput)((Object)this.redundancyRoleField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.redundancyRoleFieldLabel.setForeground(Color.yellow);
            } else {
                this.redundancyRoleFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createredundancyAtmAddrField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.RedundancyAtmAddr.access", "read-write");
            LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.RedundancyAtmAddr.length", "20");
            this.redundancyAtmAddrFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.redundancyAtmAddrFieldLabel = new Label(LesGeneralPanel.getNLSString("redundancyAtmAddrLabel"), 2);
            if (this.redundancyAtmAddrFieldWritable) {
                ATMAddressInput aTMAddressInput = new ATMAddressInput();
                this.addRow(this.redundancyAtmAddrFieldLabel, (Component)aTMAddressInput);
                LesGeneralPanel.this.containsWritableField = true;
                return aTMAddressInput;
            }
            ATMAddressInputRO aTMAddressInputRO = new ATMAddressInputRO();
            this.addRow(this.redundancyAtmAddrFieldLabel, (Component)aTMAddressInputRO);
            return aTMAddressInputRO;
        }

        protected Serializable getredundancyAtmAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.redundancyAtmAddrField);
            this.validateredundancyAtmAddrField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setredundancyAtmAddrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.redundancyAtmAddrField);
                jDMInput.setValue(object);
                this.validateredundancyAtmAddrField();
            }
        }

        protected boolean validateredundancyAtmAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.redundancyAtmAddrField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.redundancyAtmAddrFieldLabel.setForeground(Color.yellow);
            } else {
                this.redundancyAtmAddrFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createibmLeServerXLesMinLecIDField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.IbmLeServerXLesMinLecID.access", "read-write");
            this.ibmLeServerXLesMinLecIDFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.ibmLeServerXLesMinLecIDFieldLabel = new Label(LesGeneralPanel.getNLSString("ibmLeServerXLesMinLecIDLabel"), 2);
            if (this.ibmLeServerXLesMinLecIDFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.ibmLeServerXLesMinLecIDFieldLabel, (Component)numericInput);
                LesGeneralPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.ibmLeServerXLesMinLecIDFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getibmLeServerXLesMinLecIDField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ibmLeServerXLesMinLecIDField);
            this.validateibmLeServerXLesMinLecIDField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setibmLeServerXLesMinLecIDField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.ibmLeServerXLesMinLecIDField);
                jDMInput.setValue(object);
                this.validateibmLeServerXLesMinLecIDField();
            }
        }

        protected boolean validateibmLeServerXLesMinLecIDField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ibmLeServerXLesMinLecIDField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.ibmLeServerXLesMinLecIDFieldLabel.setForeground(Color.yellow);
            } else {
                this.ibmLeServerXLesMinLecIDFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createibmLeServerXLesMaxLecIDField() {
            String string = LesGeneralPanel.this.getOverride("ibm.nways.lane.model.Les.Panel.IbmLeServerXLesMaxLecID.access", "read-write");
            this.ibmLeServerXLesMaxLecIDFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.ibmLeServerXLesMaxLecIDFieldLabel = new Label(LesGeneralPanel.getNLSString("ibmLeServerXLesMaxLecIDLabel"), 2);
            if (this.ibmLeServerXLesMaxLecIDFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.ibmLeServerXLesMaxLecIDFieldLabel, (Component)numericInput);
                LesGeneralPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.ibmLeServerXLesMaxLecIDFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getibmLeServerXLesMaxLecIDField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ibmLeServerXLesMaxLecIDField);
            this.validateibmLeServerXLesMaxLecIDField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setibmLeServerXLesMaxLecIDField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.ibmLeServerXLesMaxLecIDField);
                jDMInput.setValue(object);
                this.validateibmLeServerXLesMaxLecIDField();
            }
        }

        protected boolean validateibmLeServerXLesMaxLecIDField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ibmLeServerXLesMaxLecIDField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.ibmLeServerXLesMaxLecIDFieldLabel.setForeground(Color.yellow);
            } else {
                this.ibmLeServerXLesMaxLecIDFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.lesAtmAddrSpecField = this.createlesAtmAddrSpecField();
            this.lesAtmAddrMaskField = this.createlesAtmAddrMaskField();
            this.lesAtmAddrActualField = this.createlesAtmAddrActualField();
            this.lesElanNameField = this.createlesElanNameField();
            this.lesLanTypeField = this.createlesLanTypeField();
            this.lesLastChangeField = this.createlesLastChangeField();
            this.lesMaxFrameSizeField = this.createlesMaxFrameSizeField();
            this.lesControlTimeOutField = this.createlesControlTimeOutField();
            this.lesOperStatusField = this.createlesOperStatusField();
            this.lesAdminStatusField = this.createlesAdminStatusField();
            this.validateJoinsWithLecsField = this.createvalidateJoinsWithLecsField();
            this.use2ControlDistributeVccsField = this.createuse2ControlDistributeVccsField();
            this.redundancyEnabledField = this.createredundancyEnabledField();
            this.redundancyRoleField = this.createredundancyRoleField();
            this.redundancyAtmAddrField = this.createredundancyAtmAddrField();
            this.ibmLeServerXLesMinLecIDField = this.createibmLeServerXLesMinLecIDField();
            this.ibmLeServerXLesMaxLecIDField = this.createibmLeServerXLesMaxLecIDField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.lesAtmAddrSpecField)).ignoreValue() && this.lesAtmAddrSpecFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesAtmAddrSpec", this.getlesAtmAddrSpecField());
                }
                if (!((JDMInput)((Object)this.lesAtmAddrMaskField)).ignoreValue() && this.lesAtmAddrMaskFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesAtmAddrMask", this.getlesAtmAddrMaskField());
                }
                if (!((JDMInput)((Object)this.lesAtmAddrActualField)).ignoreValue() && this.lesAtmAddrActualFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesAtmAddrActual", this.getlesAtmAddrActualField());
                }
                if (!((JDMInput)((Object)this.lesElanNameField)).ignoreValue() && this.lesElanNameFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesElanName", this.getlesElanNameField());
                }
                if (!((JDMInput)((Object)this.lesLanTypeField)).ignoreValue() && this.lesLanTypeFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesLanType", this.getlesLanTypeField());
                }
                if (!((JDMInput)((Object)this.lesLastChangeField)).ignoreValue() && this.lesLastChangeFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesLastChange", this.getlesLastChangeField());
                }
                if (!((JDMInput)((Object)this.lesMaxFrameSizeField)).ignoreValue() && this.lesMaxFrameSizeFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesMaxFrameSize", this.getlesMaxFrameSizeField());
                }
                if (!((JDMInput)((Object)this.lesControlTimeOutField)).ignoreValue() && this.lesControlTimeOutFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesControlTimeOut", this.getlesControlTimeOutField());
                }
                if (!((JDMInput)((Object)this.lesOperStatusField)).ignoreValue() && this.lesOperStatusFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesOperStatus", this.getlesOperStatusField());
                }
                if (!((JDMInput)((Object)this.lesAdminStatusField)).ignoreValue() && this.lesAdminStatusFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.LesAdminStatus", this.getlesAdminStatusField());
                }
                if (!((JDMInput)((Object)this.validateJoinsWithLecsField)).ignoreValue() && this.validateJoinsWithLecsFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.ValidateJoinsWithLecs", this.getvalidateJoinsWithLecsField());
                }
                if (!((JDMInput)((Object)this.use2ControlDistributeVccsField)).ignoreValue() && this.use2ControlDistributeVccsFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.Use2ControlDistributeVccs", this.getuse2ControlDistributeVccsField());
                }
                if (!((JDMInput)((Object)this.redundancyEnabledField)).ignoreValue() && this.redundancyEnabledFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.RedundancyEnabled", this.getredundancyEnabledField());
                }
                if (!((JDMInput)((Object)this.redundancyRoleField)).ignoreValue() && this.redundancyRoleFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.RedundancyRole", this.getredundancyRoleField());
                }
                if (!((JDMInput)((Object)this.redundancyAtmAddrField)).ignoreValue() && this.redundancyAtmAddrFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.RedundancyAtmAddr", this.getredundancyAtmAddrField());
                }
                if (!((JDMInput)((Object)this.ibmLeServerXLesMinLecIDField)).ignoreValue() && this.ibmLeServerXLesMinLecIDFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.IbmLeServerXLesMinLecID", this.getibmLeServerXLesMinLecIDField());
                }
                if (!((JDMInput)((Object)this.ibmLeServerXLesMaxLecIDField)).ignoreValue() && this.ibmLeServerXLesMaxLecIDFieldWritable) {
                    LesGeneralPanel.this.PanelInfo.add("Panel.IbmLeServerXLesMaxLecID", this.getibmLeServerXLesMaxLecIDField());
                    return;
                }
            } else {
                LesGeneralPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("accessDataMsg"));
            try {
                this.setlesAtmAddrSpecField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesAtmAddrSpec", LesGeneralPanel.this.LesConfTableIndex));
                this.setlesAtmAddrMaskField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesAtmAddrMask", LesGeneralPanel.this.LesConfTableIndex));
                this.setlesAtmAddrActualField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesAtmAddrActual", LesGeneralPanel.this.LesConfTableIndex));
                this.setlesElanNameField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesElanName", LesGeneralPanel.this.LesConfTableIndex));
                this.setlesLanTypeField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesLanType", LesGeneralPanel.this.LesConfTableIndex));
                this.setlesLastChangeField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesLastChange", LesGeneralPanel.this.LesConfTableIndex));
                this.setlesMaxFrameSizeField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesMaxFrameSize", LesGeneralPanel.this.LesConfTableIndex));
                this.setlesControlTimeOutField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesControlTimeOut", LesGeneralPanel.this.LesConfTableIndex));
                this.setlesOperStatusField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesOperStatus", LesGeneralPanel.this.LesConfTableIndex));
                this.setlesAdminStatusField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesAdminStatus", LesGeneralPanel.this.LesConfTableIndex));
                this.setvalidateJoinsWithLecsField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.ValidateJoinsWithLecs", LesGeneralPanel.this.LesConfTableIndex));
                this.setuse2ControlDistributeVccsField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.Use2ControlDistributeVccs", LesGeneralPanel.this.LesConfTableIndex));
                this.setredundancyEnabledField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.RedundancyEnabled", LesGeneralPanel.this.LesConfTableIndex));
                this.setredundancyRoleField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.RedundancyRole", LesGeneralPanel.this.LesConfTableIndex));
                this.setredundancyAtmAddrField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.RedundancyAtmAddr", LesGeneralPanel.this.LesConfTableIndex));
                this.setibmLeServerXLesMinLecIDField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.IbmLeServerXLesMinLecID", LesGeneralPanel.this.LesConfTableIndex));
                this.setibmLeServerXLesMaxLecIDField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.IbmLeServerXLesMaxLecID", LesGeneralPanel.this.LesConfTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            LesGeneralPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setlesAtmAddrSpecField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesAtmAddrSpec", LesGeneralPanel.this.LesConfTableIndex));
            this.setlesAtmAddrMaskField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesAtmAddrMask", LesGeneralPanel.this.LesConfTableIndex));
            this.setlesAtmAddrActualField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesAtmAddrActual", LesGeneralPanel.this.LesConfTableIndex));
            this.setlesElanNameField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesElanName", LesGeneralPanel.this.LesConfTableIndex));
            this.setlesLanTypeField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesLanType", LesGeneralPanel.this.LesConfTableIndex));
            this.setlesLastChangeField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesLastChange", LesGeneralPanel.this.LesConfTableIndex));
            this.setlesMaxFrameSizeField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesMaxFrameSize", LesGeneralPanel.this.LesConfTableIndex));
            this.setlesControlTimeOutField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesControlTimeOut", LesGeneralPanel.this.LesConfTableIndex));
            this.setlesOperStatusField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesOperStatus", LesGeneralPanel.this.LesConfTableIndex));
            this.setlesAdminStatusField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.LesAdminStatus", LesGeneralPanel.this.LesConfTableIndex));
            this.setvalidateJoinsWithLecsField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.ValidateJoinsWithLecs", LesGeneralPanel.this.LesConfTableIndex));
            this.setuse2ControlDistributeVccsField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.Use2ControlDistributeVccs", LesGeneralPanel.this.LesConfTableIndex));
            this.setredundancyEnabledField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.RedundancyEnabled", LesGeneralPanel.this.LesConfTableIndex));
            this.setredundancyRoleField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.RedundancyRole", LesGeneralPanel.this.LesConfTableIndex));
            this.setredundancyAtmAddrField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.RedundancyAtmAddr", LesGeneralPanel.this.LesConfTableIndex));
            this.setibmLeServerXLesMinLecIDField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.IbmLeServerXLesMinLecID", LesGeneralPanel.this.LesConfTableIndex));
            this.setibmLeServerXLesMaxLecIDField(LesGeneralPanel.this.LesConfTableData.getValueAt("Panel.IbmLeServerXLesMaxLecID", LesGeneralPanel.this.LesConfTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.redundancyRoleField)).ignoreValue() && !this.validateredundancyRoleField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.ibmLeServerXLesMinLecIDField)).ignoreValue() && !this.validateibmLeServerXLesMinLecIDField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.redundancyEnabledField)).ignoreValue() && !this.validateredundancyEnabledField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.lesAtmAddrSpecField)).ignoreValue() && !this.validatelesAtmAddrSpecField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.lesElanNameField)).ignoreValue() && !this.validatelesElanNameField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.lesAtmAddrMaskField)).ignoreValue() && !this.validatelesAtmAddrMaskField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.validateJoinsWithLecsField)).ignoreValue() && !this.validatevalidateJoinsWithLecsField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.lesMaxFrameSizeField)).ignoreValue() && !this.validatelesMaxFrameSizeField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.lesLanTypeField)).ignoreValue() && !this.validatelesLanTypeField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.ibmLeServerXLesMaxLecIDField)).ignoreValue() && !this.validateibmLeServerXLesMaxLecIDField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.use2ControlDistributeVccsField)).ignoreValue() && !this.validateuse2ControlDistributeVccsField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.lesControlTimeOutField)).ignoreValue() && !this.validatelesControlTimeOutField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.lesAdminStatusField)).ignoreValue() && !this.validatelesAdminStatusField()) {
                return false;
            }
            return ((JDMInput)((Object)this.redundancyAtmAddrField)).ignoreValue() || this.validateredundancyAtmAddrField();
        }
    }

    public class LesConfTable
    extends Table {
        public ModelInfo setRow() {
            try {
                LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("startSendMsg"));
                LesGeneralPanel.this.PanelInfo = LesGeneralPanel.this.Les_model.setInfo("Panel", LesGeneralPanel.this.PanelInfo);
                LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("endSendMsg"));
                if (LesGeneralPanel.this.PanelInfo != null) {
                    Enumeration enumeration = LesGeneralPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = LesGeneralPanel.this.PanelInfo.get(string);
                        LesGeneralPanel.this.LesConfTableInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LesGeneralPanel.this.LesConfTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    LesGeneralPanel.this.LesConfTableInfo = null;
                    LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("startRow"));
                    LesGeneralPanel.this.PanelInfo = LesGeneralPanel.this.Les_model.getNextInfo("Panel", "default", modelInfo);
                    LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("endRow"));
                    if (LesGeneralPanel.this.PanelInfo != null) {
                        LesGeneralPanel.this.LesConfTableInfo = new ModelInfo();
                        if (LesGeneralPanel.this.PanelInfo.isBeingMonitored()) {
                            LesGeneralPanel.this.LesConfTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = LesGeneralPanel.this.PanelInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = LesGeneralPanel.this.PanelInfo.get(string);
                            LesGeneralPanel.this.LesConfTableInfo.add(string, serializable);
                        }
                    }
                    if (LesGeneralPanel.this.LesConfTableInfo != null && !this.validRow(LesGeneralPanel.this.LesConfTableInfo)) {
                        modelInfo = LesGeneralPanel.this.LesConfTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LesGeneralPanel.this.LesConfTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            LesGeneralPanel.this.LesConfTableInfo = null;
            try {
                LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("startRow"));
                LesGeneralPanel.this.PanelInfo = LesGeneralPanel.this.Les_model.getInfo("Panel", "default", modelInfo);
                LesGeneralPanel.this.displayMsg(LesGeneralPanel.getNLSString("endRow"));
                if (LesGeneralPanel.this.PanelInfo != null) {
                    LesGeneralPanel.this.LesConfTableInfo = new ModelInfo();
                    if (LesGeneralPanel.this.PanelInfo.isBeingMonitored()) {
                        LesGeneralPanel.this.LesConfTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = LesGeneralPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = LesGeneralPanel.this.PanelInfo.get(string);
                        LesGeneralPanel.this.LesConfTableInfo.add(string, serializable);
                    }
                }
                if (LesGeneralPanel.this.LesConfTableInfo != null && !this.validRow(LesGeneralPanel.this.LesConfTableInfo)) {
                    LesGeneralPanel.this.LesConfTableInfo = this.getRow(LesGeneralPanel.this.LesConfTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return LesGeneralPanel.this.LesConfTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (LesGeneralPanel.this.LesConfTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            LesGeneralPanel.this.LesConfTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        LesGeneralPanel.this.LesConfTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        LesGeneralPanel.this.LesConfTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    LesGeneralPanel.this.LesConfTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            try {
                if (string.equals("Panel.LesOperStatus")) {
                    string2 = enumStrings.getString(LesModel.Panel.LesOperStatusEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            try {
                if (string.equals("Panel.LesAdminStatus")) {
                    string2 = enumStrings.getString(LesModel.Panel.LesAdminStatusEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            return string2;
        }

        public LesConfTable() {
            LesGeneralPanel.this = LesGeneralPanel.this;
        }
    }
}

